/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.HoldingEnchantableProvider;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.ThermalExplosiveLaunching;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class CoFHCore
implements IThirdParty {
    private static boolean cofhVersionOK;

    @Override
    public void preInit() {
        cofhVersionOK = this.checkForEnchantableItemInterface();
        if (cofhVersionOK) {
            MinecraftForge.EVENT_BUS.register(CapabilityListener.class);
            HoldingEnchantableProvider.registerEnchantment();
        }
    }

    @Override
    public void init() {
        if (cofhVersionOK) {
            HoldingEnchantableProvider.registerVolumeModifier();
            if (ModList.get().isLoaded("thermal")) {
                ThermalExplosiveLaunching.registerLaunchBehaviour();
            }
        }
    }

    private boolean checkForEnchantableItemInterface() {
        try {
            Class.forName("cofh.lib.capability.IEnchantableItem");
            return true;
        }
        catch (ClassNotFoundException e) {
            Log.error("CoFH IEnchantableItem interface is not where we expected! Continuing, but PneumaticCraft items won't be able to use the Holding enchantment. Notify the PNC mod author, including the versions of PNC and CoFH Core you're using, if you see this error.", new Object[0]);
            return false;
        }
    }

    public static class CapabilityListener {
        @SubscribeEvent
        public static void attachCap(AttachCapabilitiesEvent<ItemStack> event) {
            if (((ItemStack)event.getObject()).m_41720_() instanceof IPressurizableItem) {
                event.addCapability(PneumaticRegistry.RL("cofh_enchantable"), (ICapabilityProvider)new HoldingEnchantableProvider());
            }
        }
    }
}

